<?php
include('conexion.php');
session_start();
?>

<!doctype html>
<html lang="en" onclick="cerrar();cerrar2()">

<head>
    <?php
    include('include/sesiones.php');
    include('include/head.php');
    ?>
    <div id="div_buscador"></div>
    <?php
    include('./php_menu/menu_principal.php');
    include('./php_menu/menu_izquierdo.php');
    ?>

    <style>
        #crearReserva {
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
            max-width: 600px;
            background-color: #f9f9f9;
        }

        /* Ocultar el contenido del acordeón por defecto */
        .acordeon-content {
            display: none;
        }

        label {
            font-weight: 600;
            margin-bottom: 11px;
            width: 100%;
            cursor: pointer;
            padding: 0 0.6em;
            box-sizing: border-box;
            transition: all 0.5s ease 0s;
            display: flex;
            /* Usa flexbox */
            align-items: center;
            /* Centra verticalmente */
            line-height: 1.5;
            /* Ajusta la altura de línea */
        }

        /* Oculta el checkbox original */
        input[type="checkbox"] {
            display: none;
        }

        /* Estilo base del label */
        input[type="checkbox"]+label {
            display: flex;
            /* Usa flexbox para alinear */
            align-items: center;
            /* Centra el contenido verticalmente */
            line-height: 1.5;
            /* Ajusta la altura de línea */
        }

        /* Estilo cuando el checkbox está deshabilitado */
        input[type="checkbox"]:disabled+label {
            color: #ccc !important;
            cursor: not-allowed;
        }

        /* Personalización del check vacío */
        input[type="checkbox"]+label:before {
            content: "";
            width: 26px;
            height: 26px;
            margin-right: 0.5em;
            /* Espacio entre el check y el texto */
            border: 2px solid #ccc;
            background: #fff;
            flex-shrink: 0;
            /* Evita que el check se reduzca */
            border-radius: 4px;
            /* Esquinas redondeadas opcional */
        }

        /* Estilo del check cuando está seleccionado */
        input[type="checkbox"]:checked+label {
            background: rgba(<?php echo hexdec(substr($conf_color, 0, 2)); ?>, <?php echo hexdec(substr($conf_color, 2, 2)); ?>, <?php echo hexdec(substr($conf_color, 4, 2)); ?>, 0.3);
            /* Usa rgba para controlar la transparencia */
        }



        /* Borde verde al seleccionar */
        input[type="checkbox"]:checked+label:before {
            border-color: #<?php echo $conf_color; ?>;
            background-color: #<?php echo $conf_color; ?>;
        }

        /* Estilo si el checkbox está deshabilitado y marcado */
        input[type="checkbox"]:checked:disabled+label {
            background: #ccc;
            color: #fff !important;
        }

        /* Borde gris si está deshabilitado */
        input[type="checkbox"]:checked:disabled+label:before {
            border-color: #bdbdbd;
        }

        /* Responsividad para pantallas pequeñas */
        @media (max-width: 650px) {
            .content {
                width: 100%;
            }
        }
    </style>
</head>

<body>
    </br>
    <section class="slider_section mt-20">
        <div class="contact_area">
            <div class="container">
                <div class="row">

                    <div class="contact_message content">

                        <div class="tm-section tm-bg-img" id="tm-section-1">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-lg-6 col-md-8">
                                        <form id="buscar_barbero" method="POST" class="p-4 bg-white shadow rounded">
                                            <h3 class="text-center mb-4">Buscar Disponibilidad</h3>
                                            <!-- Entrada -->
                                            <div class="mb-3">
                                                <h4>
                                                    <label for="fechaInput_busqueda" class="form-label fw-bold">Fecha Reserva</label>
                                                </h4>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fa fa-calendar text-muted"></i></span>
                                                    <input name="fecha_busqueda" type="date" class="form-control" id="fechaInput_busqueda" required min="<?php echo date('Y-m-d'); ?>">
                                                </div>
                                            </div>
                                            <!-- Botón -->
                                            <div class="d-grid">
                                                <button type="submit" class="btn btn-danger">Buscar barberos disponibles</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tm-section tm-bg-img" id="tm-section-1" style="padding: 40px 0; background-color: #f8f9fa;">
                            <div class="container">
                                <div class="row g-2">
                                    <?php include 'reserva/barberos.php' ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <div class="modal fade" id="modal_box" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <a class="b-close" data-bs-dismiss="modal" aria-label="Close">
                    <div id="popup2">
                        <span class="b-close" data-bs-dismiss="modal" aria-label="Close">X</span>
                    </div>
                </a>
                <div class="modal_body">
                    <div class="container">
                        <div class="row">
                            <div id="resultados_login"></div>
                            <!-- Sección de inicio de sesión -->
                            <div class="col-lg-12 col-md-12 col-sm-12" id="login_section">
                                <div class="modal_right">
                                    <div class="modal_title mb-10">
                                        <h2>Crear Reserva</h2>
                                    </div>
                                    <div class="variants_selects">
                                        <div class="contact_message form">
                                            <form id="form_reserva" method="post">
                                                <input type="hidden" name="barbero_id" id="barberoId">

                                                <div class="mb-3">
                                                    <label for="barberoN" class="col-form-label">Barbero</label>
                                                    <input type="text" class="form-control" name="barbero_id" id="barberoN" disabled>
                                                    <label for="fechaInput_turno" class="col-form-label">Fecha</label>
                                                    <input type="date" name="fecha" class="form-control" id="fechaInput_turno" min="<?php echo date('Y-m-d'); ?>" required>
                                                    <label for="turnoSelect" class="col-form-label">Turnos</label>
                                                    <select class="form-select" name="turnoSelect" id="turnoSelect" aria-label="Default select example" required>
                                                        <option value="">Seleccione un turno</option>
                                                    </select>
                                                </div>
                                                <?php
                                                // Consulta de familias y conversión a un array
                                                $categorias = [];
                                                $categoria_query = $con->query("SELECT fam_id, fam_nombre FROM familias  WHERE empresa = '$emp_id'");
                                                while ($fila_categoria = $categoria_query->fetch_assoc()) {
                                                    $categorias[$fila_categoria['fam_id']] = $fila_categoria['fam_nombre'];
                                                }
                                                // Consulta de servicios y agrupación por familia
                                                $servicios_por_familia = [];
                                                $servicios_query = $con->query("SELECT familias_fam_id, art_id, art_nombre, art_pvp FROM articulos WHERE empresa = '$emp_id' AND art_tipo = 'servicio' AND art_pvp > 0");
                                                while ($fila_servicio = $servicios_query->fetch_assoc()) {
                                                    $servicios_por_familia[$fila_servicio['familias_fam_id']][] = $fila_servicio;
                                                }
                                                ?>
                                                <div class="mb-3">
                                                    <label for="servicios" class="col-form-label">Servicios:</label>
                                                    <div id="servicios">
                                                        <div class="accordion" id="accordionExample">
                                                            <?php
                                                            $familia_ids = array_keys($categorias);
                                                            for ($i = 0; $i < count($familia_ids); $i++):
                                                                $familia_id_actual = $familia_ids[$i];
                                                                $familia_nombre_actual = $categorias[$familia_id_actual];
                                                                // Saltar familias sin servicios
                                                                if (!isset($servicios_por_familia[$familia_id_actual])) continue;
                                                            ?>
                                                                <h2 class="accordion-header">
                                                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?= $familia_id_actual ?>" aria-expanded="true" aria-controls="collapse-<?= $familia_id_actual ?>" style="padding: 0.5rem 1rem; border: none; border-radius: 5px; margin: auto;">
                                                                        <?= htmlspecialchars($familia_nombre_actual) ?>
                                                                    </button>
                                                                </h2>
                                                                <div id="collapse-<?= $familia_id_actual ?>" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                                                    <div class="accordion-body">
                                                                        <?php
                                                                        $servicios = $servicios_por_familia[$familia_id_actual];
                                                                        for ($j = 0; $j < count($servicios); $j++):
                                                                            $servicio_actual = $servicios[$j];
                                                                        ?>
                                                                            <div>
                                                                                <input class="servicio-check" type="checkbox" name="servicio[]" value="<?= $servicio_actual['art_id'] ?>" data-precio="<?= $servicio_actual['art_pvp'] ?>" id="servicio-<?= $servicio_actual['art_id'] ?>" onchange="calcularTotal()">
                                                                                <label for="servicio-<?= $servicio_actual['art_id'] ?>">
                                                                                    <?= htmlspecialchars($servicio_actual['art_nombre']) ?> - $<?= number_format($servicio_actual['art_pvp'], 2) ?>
                                                                                </label>
                                                                            </div>
                                                                        <?php endfor; ?>
                                                                    </div>
                                                                </div>
                                                                </br>
                                                            <?php endfor; ?>
                                                        </div>
                                                    </div>

                                                    <div class="mb-3">
                                                        <strong>Total a Pagar: $<span id="totalPrecio">0.00</span></strong>
                                                    </div>
                                                    <div id="resultados"></div>
                                                    <div class="modal-footer">
                                                        <button type="button" data-bs-dismiss="modal">Cancelar</button>
                                                        <button type="submit" id="reservaModal" class="btn btn-primary">Guardar Reserva</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/main.js"></script>
    <!-- Script para manejar el modal -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Función para cargar barbero
        function cargarBarbero(id, nombre) {
            document.getElementById('barberoId').value = id;
            document.getElementById('barberoN').value = nombre;
        }
        // Función para calcular el total de la reserva
        function calcularTotal() {
            let total = 0;

            document.querySelectorAll('.servicio-check:checked').forEach(function(servicio) {
                total += parseFloat(servicio.getAttribute('data-precio'));
            });
            document.getElementById('totalPrecio').textContent = total.toFixed(2);
        }

        // Función para cargar la fecha
        function cargarfecha(fecha) {
            const fechaInput = document.getElementById('fechaInput_turno');
            if (!fechaInput.value) {
                fechaInput.value = fecha;
            }
        }

        function cargarTurnos() {
            const barberoId = document.getElementById('barberoId').value;
            const fecha = document.getElementById('fechaInput_turno').value;

            if (!barberoId || !fecha) return; // Validar que ambos campos estén completos

            fetch(`reserva/buscar_turnos.php?t=${Date.now()}`, { // Agregar un parámetro único
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: `barb_res_fecha=${encodeURIComponent(fecha)}&barbero_id=${encodeURIComponent(barberoId)}`
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`Error al cargar los turnos. Código: ${response.status}`);
                    }
                    return response.text();
                })
                .then(data => {
                    const turnoSelect = document.getElementById('turnoSelect');
                    turnoSelect.innerHTML = `<option value="">Seleccione un turno</option>`;

                    if (data.trim() === '' || data.includes("No hay turnos disponibles")) {
                        alert("No hay turnos disponibles para la fecha y barbero seleccionados.");
                    } else {
                        turnoSelect.innerHTML += data; // Agregar los turnos disponibles
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert("Hubo un error al cargar los turnos.");
                });
        }
        // Cargar turnos al abrir el modal
        document.getElementById('modal_box').addEventListener('shown.bs.modal', cargarTurnos);
        // Cargar turnos cuando cambian el barbero o la fecha
        document.getElementById('fechaInput_turno').addEventListener('change', cargarTurnos);
        document.getElementById('barberoId').addEventListener('change', cargarTurnos);
        $("#form_reserva").submit(function(event) {
            event.preventDefault();
            // Verificar si al menos un servicio está seleccionado
            if ($(".servicio-check:checked").length === 0) {
                Swal.fire({
                    title: "Error",
                    text: "Debe seleccionar al menos un servicio antes de continuar.",
                    icon: "error"
                });
                return; // Detener el proceso si no hay servicios seleccionados
            }
            $("#reservaModal").prop("disabled", true); // Deshabilitar el botón de envío temporalmente
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "reserva/reservar.php",
                data: parametros,
                success: function(datos) {
                    $("#resultados").html(datos);
                    $('#reservaModal').attr("disabled", false);
                    Swal.fire({
                        title: "Reserva registrada!",
                        text: datos,
                        icon: "success"
                    }).then((result) => {
                        if (result.isConfirmed || result.isDismissed) {
                            window.location.href = window.location.href;
                        }
                    });
                },
                error: function() {
                    Swal.fire({
                        title: "Error",
                        text: "Hubo un problema al procesar la reserva.",
                        icon: "error"
                    });
                    $('#reservaModal').attr("disabled", false);
                }
            });
        });
    </script>
    <script>
        function buscador() {
            $.get("./php_menu/buscador.php", "", function(data) {
                $("#div_buscador").html(data);
            })
        }
        buscador();



        function loadArticulos() {
            $.get("./php_tienda/tabla_articulos.php", "", function(data) {
                $("#mis_articulos").html(data);
            })
        }
        loadArticulos();
        buscador();


        function envia_carrito1(art_id, cantidad) {
            var parametros = {
                "art_id": art_id,
                "cantidad": cantidad
            };
            $.ajax({
                data: parametros,
                url: './php_tienda/sessiones_cart.php',
                type: 'POST',
                beforeSend: function() {
                    $('#resultados').html('');
                },
                success: function(datos) {
                    $("#resultados").html(datos);
                    loadArticulos();
                    buscador();
                }
            });
        }



        function envia_deseos(art_id) {
            var parametros = {
                "art_id": art_id
            };
            $.ajax({
                data: parametros,
                url: './php_tienda/registrar_deseos.php',
                type: 'POST',
                beforeSend: function() {
                    $('#resultados').html('');
                },
                success: function(datos) {
                    $("#resultados").html(datos);
                    loadArticulos();
                    buscador();
                }
            });
        }



        function eliminar_deseo(art_id) {
            var parametros = {
                "art_id": art_id
            };
            $.ajax({
                data: parametros,
                url: './php_tienda/eliminar_deseo.php',
                type: 'POST',
                beforeSend: function() {
                    $('#resultados').html('');
                },
                success: function(datos) {
                    $("#resultados").html(datos);
                    loadArticulos();
                    buscador();
                }
            });
        }
    </script>

</body>

</html>